#
# Example for building demo OCI programs:
#
# 1. All OCI demos:
#
#    make -f demo_ordimg.mk demos
#
# 2. A single OCI demo:
#
#    make -f demo_ordimg.mk imgdemo
#
# NOTE: 1. ORACLE_HOME must be either:
#		   . set in the user's environment
#		   . passed in on the command line
#		   . defined in a modified version of this makefile
#
#       2. If the target platform support shared libraries (e.g. Solaris)
#          look in the platform specific documentation for information
#          about environment variables that need to be properly
#          defined (e.g. LD_LIBRARY_PATH in Solaris).
#

include $(ORACLE_HOME)/rdbms/lib/env_rdbms.mk

# flag for linking with non-deferred option (default is deferred mode)
NONDEFER=false

DEMO_MAKEFILE = demo_ordimg.mk
 
DEMOS = imgdemo

.SUFFIXES: .o 

demos: $(DEMOS)

$(DEMOS):
	$(MAKE) -f $(DEMO_MAKEFILE) build EXE=$@ OBJS=$@.o

build: $(OBJS)
	$(BUILDEXE)

build_static: $(OBJS)
	$(O2STATIC)

clean:
	$(RM) -f $(DEMOS) *.o

